unit EngineMainData01;
(*
   ========================================================================
    " " GraphEngine.
         .
   ========================================================================
       :
   1)       .
   2)      
   3)  DitMap      
   4)  DitMap  TColor    
   ========================================================================
   ()  ,    , , .
   ========================================================================
 *)
interface
uses //  
     Types, Graphics, Dialogs, SysUtils, ExtCtrls;

// ========================================================================
//    GraphEngine
// ========================================================================
//       
// ,    32768 . 
//     BitMap  Bitmap.ScanLine[Row]
  type
  PtArrayByte = ^TArrayByte;
  TArrayByte  = array[0..65535] of Byte;

// ------------------------------------------------------------------------
//         
//       BitMap c PixelFormat = pf24bit
  type
  ptArrayBGR  = ^TArrayBGR;
  TArrayBGR   = array[0..2] of byte;

// ------------------------------------------------------------------------
//      ,  
//      BitMap c PixelFormat = pf24bit.
//      BitMap   
//     byte.
  type
  ptImgTabBGR = ^TImgTabBGR;
  TImgTabBGR  = array of array of byte;

// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
//     BitMap c PixelFormat = pf24bit
  type TColorByte = packed record
    B : byte;   //  
    G : byte;   //  
    R : byte;   //  
  end;

// ------------------------------------------------------------------------
//      ,  
//      BitMap c PixelFormat = pf24bit.
//      BitMap   
//     TColorByte.
  type
  ptImgTabColor = ^TImgTabColor;
  TImgTabColor = array of array of TColorByte;

// ========================================================================
//    GraphEngine
// ========================================================================
//     TColor     RGB 
function SplitRGB(RqColor : TColor) : TColorByte;

// -------------------------------------------------------------------
//    
function EqualPoints(const P1, P2: TPoint): Boolean;

// -------------------------------------------------------------------
//      
//  ,      
// (Top, Left)  (Bottom, Right).
function NoarmalRect (RqBeg, RqEnd : TPoint) : TRect;

// -------------------------------------------------------------------
//      ()
//  ,      (Top, Left)  (Bottom, Right)
function IsRectEmpty(const Rect: TRect): Boolean;

// -------------------------------------------------------------------
//    (Rect)   (R1, R2)
function CrossRect(out Rect: TRect; const R1, R2: TRect): Boolean;

// -------------------------------------------------------------------
//   Image  
procedure ClearImage (RqImage : TImage; RqColor : TColor);

// -------------------------------------------------------------------
//         
function ProStrToFloat (RqStr : string; var RqFloat : extended) : boolean;

// -------------------------------------------------------------------
//         
function ProStrToInt (RqStr : string; var RqInt : integer) : boolean;

// -------------------------------------------------------------------
//   RqRec  RqBitMap
function CutRecToBitMap (RqBitMap : TBitMap; RqRec : TRect) : TRect;

// ========================================================================
// ========================================================================
implementation
// ========================================================================
// ========================================================================

//     TColor     BGR 
function SplitRGB(RqColor : TColor) : TColorByte;
begin
   SplitRGB.R := RqColor and $000000ff;
   RqColor := RqColor shr 8;
   SplitRGB.G := RqColor and $000000ff;
   RqColor := RqColor shr 8;
   SplitRGB.B := RqColor and $000000ff;
end;

// -------------------------------------------------------------------
//    
function EqualPoints(const P1, P2: TPoint): Boolean;
begin
  Result := (P1.X = P2.X) and (P1.Y = P2.Y);
end;

// -------------------------------------------------------------------
//      
//  ,      
// (Top, Left)  (Bottom, Right)
function NoarmalRect (RqBeg, RqEnd : TPoint) : TRect;
begin
   if RqEnd.X < RqBeg.X
   then  // 1.     - 
      if RqEnd.Y < RqBeg.Y
      then  // 1.1.     - 
         Result := Rect(RqEnd.X, RqEnd.Y, RqBeg.X, RqBeg.Y )
      else  // 1.2.     - 
         Result := Rect(RqEnd.X, RqBeg.Y, RqBeg.X, RqEnd.Y )
   else  // 2     -  ()
      if RqEnd.Y < RqBeg.Y
      then  // 2.1.     - 
         Result := Rect(RqBeg.X, RqEnd.Y, RqEnd.X, RqBeg.Y )
      else  // 2.2.     -  ()
         Result := Rect(RqBeg.X, RqBeg.Y, RqEnd.X, RqEnd.Y );
end; // of function

// -------------------------------------------------------------------
//      ()
//  ,      (Top, Left)  (Bottom, Right)
function IsRectEmpty(const Rect: TRect): Boolean;
begin
  Result := (Rect.Right <= Rect.Left) or (Rect.Bottom <= Rect.Top);
end;

// -------------------------------------------------------------------
//    (Rect)   (R1, R2)
//  ,       
//  ,      .
function CrossRect(out Rect: TRect; const R1, R2: TRect): Boolean;
begin
  Rect := R1;
  if R2.Left   > R1.Left   then Rect.Left   := R2.Left;
  if R2.Top    > R1.Top    then Rect.Top    := R2.Top;
  if R2.Right  < R1.Right  then Rect.Right  := R2.Right;
  if R2.Bottom < R1.Bottom then Rect.Bottom := R2.Bottom;
  Result := not IsRectEmpty(Rect);
  if not Result then FillChar(Rect, SizeOf(Rect), 0);
end;

// -------------------------------------------------------------------
//   Image  
procedure ClearImage (RqImage : TImage; RqColor : TColor);
begin
  with RqImage.Canvas do
  begin
    Brush.Style := bsSolid;
    Brush.Color := RqColor;
    FillRect(Rect(0,0, RqImage.Width, RqImage.Height));
  end;
end;
//------------------------------------------------------------------------
//         
function ProStrToFloat (RqStr : string; var RqFloat : extended) : boolean;
begin
  Result  := False;
  try
    if RqStr <> ''
    then RqFloat := StrToFloat(RqStr)
    else RqFloat := 0;
    Result  := True;
  except
      MessageDlg('    : ' + RqStr
                +   #13#10
                + '    .',
                mtWarning, [mbOk], 0);
  end;
end;
//------------------------------------------------------------------------
//         
function ProStrToInt (RqStr : string; var RqInt : integer) : boolean;
begin
  Result  := False;
  try
    if RqStr <> ''
    then RqInt := StrToInt(RqStr)
    else RqInt := 0;
    Result := True;
  except
     MessageDlg('    : ' + RqStr
                +   #13#10
                + '    .',
                mtWarning, [mbOk], 0);
  end;
end;

// ========================================================================
//
//        3.5
//
// ========================================================================
// 29.03.2014
//   RqRec  RqBitMap.  
//   RqBitMap.   
//   RqBitMap.
function CutRecToBitMap (RqBitMap : TBitMap; RqRec : TRect) : TRect;
begin
  Result := RqRec;
  if RqRec.Left < 0 then Result.Left := 0;
  if RqRec.Top  < 0 then Result.Top  := 0;
  if RqRec.Right > RqBitMap.Width - 1
  then Result.Right := RqBitMap.Width -1;
  if RqRec.Bottom > RqBitMap.Height - 1
  then Result.Bottom := RqBitMap.Width - 1;

end;

// ========================================================================
//               END OF IMPLEMENTATION
// ========================================================================
end.
